extern float4	g_Dimensions :	register(c1);

#define			BORDER_SIZE		0.004f



struct VS_OUTPUT
{
	float4	m_Position :	POSITION;
	float4	m_Colour :		COLOR0;
	float2	m_TexCoord :	TEXCOORD0;
};



struct VS_INPUT
{
	float4	m_Position :	POSITION;
	float2	m_TexCoord :	TEXCOORD0;
};



VS_OUTPUT MainVS(VS_INPUT input)
{

	VS_OUTPUT output	=	(VS_OUTPUT) 0;
	
	float4	position	=	sign(input.m_Position);
	float2	borderAdj	=	(input.m_Position.xy - position.xy) * BORDER_SIZE;
	
	position.xy			*=	g_Dimensions.zw;
	position.xy			+=	2.0f * (g_Dimensions.xy - 0.5f);
	position.xy			+=	borderAdj;
	
	output.m_Position	=	position;
	output.m_Colour		=	float4(1.0f, 1.0f, 1.0f, 1.0f);
	output.m_TexCoord	=	input.m_TexCoord;

	return output;

}